;*****************************************************************************************************************
;Source File Name:
;		oscres.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW Script file for aim.exe, the executable program for the AOL instant messenger.
;Included Header Files:
;		hjconst.jsh			default HJ constants 
;		hjglobal.jsh		default HJ global variables
;		aim.jsm				Global Message file for the entire AIM Project.
;		aim.jsh					Globals and constants specific to aim.exe
;*****************************************************************************************************************
;																Member Functions
;*****************************************************************************************************************
;
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Project started
; 06/25/1999		Ben Key
;	Aim.jss added to the AOL Instant messenger project
; 06/25/1999 	Ben Key
;	ScreenSensitiveHelpForKnownClasses added
; 06/25/1999		Ben Key
;	ScriptFileName Added
; 06/28/1999		Ben Key
;	Complete reorganization of the project in attempt to resolve problems 
;	encountered previously
; 06/28/1999		Ben Key
;	Problems with New User Wizard dialog boxes resolved by better controling
;	the interraction between FocusChangedEvent (...) and 
;	SayNonHighlightedText (...)
; 06/29/1999		Ben Key
;	Added entry in aim.jcf to treat custom highlight colors in buddy list.
; 06/29/1999		Ben Key
;	Added support for Profile Wizard
; 06/29/1999		Ben Key
;	Added SelectATool Script for the "Create a Profile - More Info" and supporting 
;	functions
; 06/29/1999		Ben Key
;	Added customized screen sensitive help for "Create a Profile - More Info" 
;	window
; 06/30/1999		Ben Key
;	Added support for Add Buddy Wizard
; 06/30/1999		Ben Key
;	Added GetActivePageName ()
;*****************************************************************************************************************

include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"

; ***/ AutoStartEvent and AutoFinishEvent functions
Void Function AutoStartEvent ()
Var
	Handle rWin, 
	Int rWinClassLen, Int FirstChildLen
Let rWin = GetRealWindow (GetFocus())
Let rWinClassLen = StringLength (GetWindowClass (rWin))
Let FirstChildLen = StringLength (GetWindowClass (GetFirstChild (rWin)))
If (rWinClassLen == iTickerParentLen 
	&& FirstChildLen == iTickerFirstChildLen) then
	StopSpeech ()
	{Alt+F4}
	ScheduleFunction ("CloseTickerWindowSecondTry", 20)
	Return
EndIf
Let numTimes = 0
If (AIMFirstTime == 0) then
	Let AIMFirstTime = 1
	If (GetVerbosity () == BEGINNER) then
		Say (msg001, ot_help)
		Say (msg002, ot_help)
	EndIf
EndIf
EndFunction



Void Function CloseTickerWindowSecondTry ()
Var
	Handle rWin, 
	Int rWinClassLen, Int FirstChildLen
Let rWin = GetRealWindow (GetFocus())
Let rWinClassLen = StringLength (GetWindowClass (rWin))
Let FirstChildLen = StringLength (GetWindowClass (GetFirstChild (rWin)))
If (rWinClassLen == iTickerParentLen 
	&& FirstChildLen == iTickerFirstChildLen) then
	StopSpeech ()
	{Alt+F4}
	Return
EndIf
EndFunction


;*****************************************************************************************************************
;Function:	
;		Void ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
;Author's Name:
;		Ben Key
;Description:
;	This function is based upon the screen scensitive help for known classes 
;	function found 	in default.jss.  It is used to customize the messages that 
;	are spoken when screen sensitive help is called for certain controls.  
;	Messages for the following controls have been customized:
;		1. buttons		Now say "This is the {button name} button" rather than 
;			"this is a button."
;		2. Read Only edit
;Parameters:
;	int nSubTypeCode
;		The window subtype code of the window that currently has focus
;Globals
;	Used:
;	Modified:
;Return Value:		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/22/1999		Ben Key
;	Project started
;*****************************************************************************************************************
Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var  int TheTypeCode, string RealName, String strTest
let theTypeCode = nSubTypeCode
if (TheTypeCode == WT_BUTTON) then ;#1
	Say (kcmsg001, ot_help) ;"This is the"
	Say (GetWindowName (GetCurrentWindow ()), ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
	Say (kcmsg004, ot_help) ;"This is a Combo box"
	Say (kcmsg005a, ot_help) ;"type in a value or use the arrow keys to move between the items"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
	Say (kcmsg007, ot_help) ;"This is an edit field in which you can type information"
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
	if (IsSelectScriptDlg()) then
		Say (kcmsg009, ot_help) ;"This is an execute item list box"
		Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
		Say (kcmsg145, ot_help) ;"Use the space bar to toggle the selected item"
		Say (kcmsg146, ot_help) ;"Use the enter key to close this dialog"
	elif (IsSelectItemDlg()) then
		Say (kcmsg147, ot_help) ;"this is a select item list box"
		Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
		Say (kcmsg148, ot_help) ;"Use enter to choose the item and exit the dialog"
		Say (kcmsg149, ot_help) ;"Use escape to cancel the dialog"
	else
		Say (kcmsg016, ot_help) ;"This is a list box"
		Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
		Say (kcmsg018, ot_help) ;"Use Enter to select it"
		Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	endif
	Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)
 then ;#5
	Say (kcmsg019, ot_help) ;"This is a scroll bar"
	Say (kcmsg020, ot_help) ;"Use the right arrow down arrow or page down keys to increase the value"
	Say (kcmsg021, ot_help) ;"Use the left arrow up arrow or page up keys to decrease the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then
	Say (kcmsg142, ot_help) ;"This is an Up Down scroll bar"
	Say (kcmsg143, ot_help) ;"Use the right arrow down arrow or page down keys to decrease the value"
	Say (kcmsg144, ot_help) ;"Use the left arrow up arrow or page up keys to increase the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	Say (kcmsg022, ot_help) ;"This is static text for information only"
	Say (kcmsg023, ot_help) ;"Use the reading keys to read the text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	Say (kcmsg024, ot_help) ;"this is a tool bar"
	Say (kcmsg025, ot_help) ;"it contains various controls and graphics"
	Say (kcmsg026, ot_help) ;"it is generally accessed with the mouse by point and click"
	Say (kcmsg027, ot_help) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	Say (kcmsg028, ot_help) ;"This is an application status bar"
	Say (kcmsg029, ot_help) ;"It provides a variety of information depending on the focus"
	Say (kcmsg030, ot_help) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	Say (kcmsg031, ot_help) ;"This is a header bar"
	Say (kcmsg032, ot_help) ;"it contains titles for various columns below the header bar"
	Say (kcmsg033, ot_help) ;"clicking on a particular title"
	Say (kcmsg034, ot_help) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	Say (kcmsg035, ot_help) ;"This is a spin box"
	Say (kcmsg036, ot_help) ;"you can edit this control manually or"
	Say (kcmsg037, ot_help) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	Say (kcmsg038, ot_help) ;"This is a menu"
	Say (kcmsg039, ot_help) ;"Use the arrow keys to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	Say (kcmsg041, ot_help) ;"This is the desktop"
	Say (kcmsg042, ot_help) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	Say (kcmsg043, ot_help) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		Say (kcmsg044, ot_help) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		Say (kcmsg045, ot_help) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	Say (kcmsg046, ot_help) ;"This is an multiple document interface client window"
	Say (kcmsg047, ot_help) ;"This is the space underlying documents in an m d i environment"
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg049, ot_help) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	Say (kcmsg050, ot_help) ;"This is one of a group of radio buttons"
	Say (kcmsg051, ot_help) ;"only one can be checked at a time"
	Say (kcmsg052, ot_help) ;"Use the up and down arrow keys to move the check mark"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	Say (kcmsg053, ot_help) ;"This is a check box"
	Say (kcmsg054, ot_help) ;"Use the space bar to toggle the check mark on and off"
	Say (kcmsg055, ot_help) ;"Read current line or word to read it"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	Say (kcmsg056, ot_help) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		Say (kcmsg057, ot_help) ;"It is used to group items that are related"
		Say (kcmsg058, ot_help) ;"such as radio buttons"
	EndIf
	Say (kcmsg059, ot_help) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg060, ot_help) ;"use tab and shift tab to move between the controls"
	Say (kcmsg061, ot_help) ;"select ok to accept the changes or cancel to ignore the changes"
	Return
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	Say (kcmsg062, ot_help) ;"This is a General picture"
	Say (kcmsg063, ot_help) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	Say (kcmsg064, ot_help) ;"This is a hot key or short cut key edit control"
	Say (kcmsg065, ot_help) ;"be careful or you may define a short cut key by pressing any letter key"
	Say (kcmsg066, ot_help) ;"or most combinations of letter key and alt control or shift"
	Say (kcmsg067, ot_help) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	Say (kcmsg068, ot_help) ;"This is a tab control found in multi page dialog boxes"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg070, ot_help) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wn187="Desktop"
	if RealName == wnDesktop then
		Say (kcmsg071, ot_help) ;"This is the desktop list view"
		Say (kcmsg072, ot_help) ;"It contains shortcut icons"
		Say (kcmsg073, ot_help) ;"use the arrow keys to move from item to item"
		Say (kcmsg074, ot_help) ;"or press the first letter of the desired item"
		Say (kcmsg075, ot_help) ;"Press enter or double click to select"
		Say (kcmsg076, ot_help) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		Say (kcmsg077, ot_help) ;"if the desktop items are not being read correctly"
		Say (kcmsg078, ot_help) ;"you may need to minimize all applications"
		Say (kcmsg079, ot_help) ;"this can be accomplished with insert plus f6"
		Return
	else
		Say (kcmsg080, ot_help) ;"This is a list view"
		Say (kcmsg081, ot_help) ;"use the arrow keys to read through the items"
		Say (kcmsg082, ot_help) ;"or press the first letter to jump to a desired item"
		Say (kcmsg083, ot_help) ;"items can be contained in one or more columns"
		Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
		Say (kcmsg085, ot_help) ;"hold down the shift key as you arrow up or down"
		Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
		Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
		Say (kcmsg088, ot_help) ;"and use control plus space bar"
		Say (kcmsg089, ot_help) ;" to select or unselect items"
		Say (kcmsg090, ot_help) ;"to here the items that have been selected"
		Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
		Say (kcmsg092, ot_help) ;"we recommend that you put files in a single column with all details"
		Say (kcmsg093, ot_help) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	Say (kcmsg094, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (kcmsg095, ot_help) ;"use up or down arrow to read through the items"
	Say (kcmsg096, ot_help) ;"or press the first letter to jump through the list"
	Say (kcmsg097, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (kcmsg098, ot_help) ;"use shift with the plus or minus key"
	Say (kcmsg099, ot_help) ;"to move to the prior level press backspace"
	Say (kcmsg100, ot_help) ;"to move to the root of the tree press home"
	Say (kcmsg101, ot_help) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	Say (kcmsg102, ot_help) ;"This is the start button"
	Say (kcmsg103, ot_help) ;"Press Enter to open the start menu"
	Say (kcmsg104, ot_help) ;"items in the start menu are used to launch applications"
	Say (kcmsg105, ot_help) ;"or tab to move to the task bar"
	Say (kcmsg106, ot_help) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	Say (kcmsg107, ot_help) ;"This is the start menu"
	Say (kcmsg108, ot_help) ;"items in this menu are used to launch applications"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	Say (kcmsg110, ot_help) ;"This is the context menu"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	Say (kcmsg111, ot_help) ;"This is the task bar"
	Say (kcmsg112, ot_help) ;" it contains the currently running applications"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg113, ot_help) ;" use enter to invoke the application"
	Say (kcmsg114, ot_help)	 ;"use alt plus enter to open the task bar properties dialog"
	Say (kcmsg115, ot_help) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (kcmsg116, ot_help) ;"This is a multiselect listbox"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
	Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
	Say (kcmsg118, ot_help) ;"and use the space bar to select the item"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	Say (kcmsg119, ot_help) ;"This is an extended select list box"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg120, ot_help) ;"use shift + f8 to toggle the extended select option"
	Say (kcmsg121, ot_help) ;"When the extended select option is on"
	Say (kcmsg122, ot_help) ;"you can select multiple items with your space bar"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	Say (kcmsg123, ot_help) ;"This is a horizontal slider"
	Say (kcmsg124, ot_help) ;"the value of the control increases as you move to the right"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	Say (kcmsg127, ot_help) ;"This is a vertical slider"
	Say (kcmsg128, ot_help) ;"the value of the control increases as you move upward"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (kcmsg129, ot_help) ;"This is an edit Combo box"
	Say (kcmsg005, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Say (kcmsg150, ot_help) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	Say (kcmsg130, ot_help) ;"This is a password edit control"
	Say (kcmsg151, ot_help) ;" visually replaced by asteriks"
	Say (kcmsg131, ot_help) ;"Use the backspace to delete and start over"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
		Say (schReadOnly1, ot_help)
		Say (schReadOnly2, ot_help)
;		Say (kcmsg132, ot_help) ;"This text is reed only"
;		Say (kcmsg133, ot_help) ;"you can navigate and read text with the jaws cursor"
;		Say (kcmsg134, ot_help) ;"but you cannot edit the text"
		Return
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	Say (kcmsg136, ot_help);"This is a command bar"
	Say (kcmsg137, ot_help);"it consists of a row of buttons"
	Say (kcmsg138, ot_help) ;"you can arrow left or right to hear the different button names"
	Say (kcmsg139, ot_help) ;"and press enter to activate a button"
	Say (kcmsg140, ot_help) ;"press control plus tab to move to the next command bar"
	Say (kcmsg141, ot_help) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	Say (kcmsg010, ot_help) ;"This is the menu bar"
	Say (kcmsg011, ot_help) ;"you can arrow left and right to hear the different menu names"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg014, ot_help) ;"press enter or down arrow to open a menu"
	Say (kcmsg015, ot_help) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
Say (kcmsg135, ot_help) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction

; ***/ Functions that obtain information about the AIM environment and perform actions 
; on the AIM environment
;*****************************************************************************************************************
;Function:	
;		String Function GetActivePageName ()
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to get the active page name in the AIM buddy 
;	list tree and in 	various	multiple page dialog boxes found throughout AIM.
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:	
;		String 		The active page name
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/30/1999		Ben Key
;	Function created
;*****************************************************************************************************************
String Function GetActivePageName ()
Var String strPageName, String rWinTitle, Handle rWin, String rWinClass, 
	Handle hTemp, String strTemp, Int nSafety
Let rWin = GetRealWindow (GetFocus())
If (GetWindowClass (rWin) == wcOscarBuddyListWin) then
	Let hTemp = GetFirstChild (rWin)
	Let nSafety = 0
	While (GetWindowClass (hTemp) != wcOscarTabGroup && nSafety < 10)
		Let hTemp = GetNextWindow (hTemp)
	EndWhile
	SaveCursor ()
	JAWSCursor ()
	MoveToWindow (hTemp)
	PriorLine ()
	JawsHome ()
	If (GetCharacterAttributes () & ATTRIB_BOLD) then
		Let strPageName = GetChunk ()
	Else
		NextWord ()
		If (GetCharacterAttributes () & ATTRIB_BOLD) then
			Let strPageName = GetChunk ()
		EndIf
	EndIf
	RestoreCursor ()
ElIf (IsEditPreferencesDialog ()) then
;	The window title of the edit preferences dialog changes to indicate the active dialog 
;	box page name.  Therefore, all that is necessary to get the active page name is to 
;	confirm that the active real window	is the Edit Preferences dialog box by using 
; IsEditPreferencesDialog () and returning the real window title.  If the edit preferences 
; dialog is not the active real window, a null string is returned.
	Let strPageName = GetWindowName (GetRealWindow (GetFocus ()))
EndIf
Return strPageName
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function ResetnSuppressEcho ()
;Author's Name:
;		Ben Key
;Description:
;	This function is scheduled by the select a tool script.  It is designed to 
;	help quite unnecessary chatter after the select a tool script is run.
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:	
;		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/29/1999		Ben Key
;	Function created
;*****************************************************************************************************************
Void Function ResetnSuppressEcho ()
Let nSuppressEcho = FALSE
EndFunction


;*****************************************************************************************************************
;Function:	
;		Handle Function GetProfileMoreInfoToolbar ()
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to return the window handle of the tool bar 
;	found in the "Create a Profile - More Info" window
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:	
;	Handle
;		Window handle of the "Create a Profile - More Info" tool bar
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/29/1999		Ben Key
;	Function created
;*****************************************************************************************************************
HANDLE Function GetProfileMoreInfoToolbar ()
Var Handle rWin, String rWinTitle, Handle hTarget, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnProfileExtendedInfo) == 0) then
	Return 0
Else
	Let hTemp = FindDescendantWindow (GetFirstChild (rWin), cID_ProfileMoreInfoToolBarParent)
	If (!hTemp) then 
		Say (msgCNF_ToolBarParent, ot_status)
	Else
		Let hTarget = FindDescendantWindow (hTemp, cID_ProfileMoreInfoToolBar)
		If (!hTarget) then
			Say (msgCNF_ToolBar, ot_status)
		EndIf
	EndIf
EndIf
Return hTarget
EndFunction

HANDLE Function GetNewAwayMsgToolBar ()
Var Handle rWin, String rWinTitle, Handle hTarget, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnNewAwayMessage) == 0) then
	Return 0
Else
	Let hTemp = FindDescendantWindow (rWin, cID_NewAwayMsgToolBarParent)
	If (!hTemp) then 
		Say (msgCNF_NAMToolBarParent, ot_status)
	Else
		Let hTarget = FindDescendantWindow (hTemp, cID_NewAwayMsgToolBar)
		If (!hTarget) then
			Say (msgCNF_NAMToolBar, ot_status)
		EndIf
	EndIf
EndIf
Return hTarget
EndFunction

;*****************************************************************************************************************
;Function:	
;		String Function BuildAvailableButtonsList (String strExpected, Int nNumMax, Handle hToolBar)
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to verify the toolbar button list passed to 
;	the select a tool script
;Parameters:
;	String strExpected
;		A delimited list of the expected tool bar buttons
;	Int nNumMax
;		The maximum number of tool bar buttons
;	Handle hToolBar
;		The window handle of the tool bar
;Globals
;	Used:				
;	Modified:		
;Return Value:	
;	String
;		List indicating the tool bar buttons that are actually available
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/29/1999		Ben Key					Function created
;*****************************************************************************************************************
String Function BuildAvailableButtonsList (string strExpected, int nNumMax, handle hToolBar)
Var Int nCount, String strAvailableButtonsList, String strCanidate, Int nLength
Let nCount = 1
Let strAvailableButtonsList = ""
While (nCount <= nNumMax)
	Let strCanidate = StringSegment (strExpected, "\007", nCount)
	If (FindGraphic (hToolBar, strCanidate, S_TOP, S_RESTRICTED)) then
		Let strAvailableButtonsList = strAvailableButtonsList + "\007" + strCanidate
	EndIf
	Delay (1)
	Let nCount = nCount + 1
EndWhile
Let nLength = StringLength (strAvailableButtonsList)
Let strAvailableButtonsList = StringRight (strAvailableButtonsList, nLength - 1)
Return strAvailableButtonsList
EndFunction

String Function GetButtonList (handle hToolBar)
Var 
	Handle rWin, String rWinClass, String strButtonName, String strButtonList
Let strButtonList = ""
Let rWin = GetRealWindow (GetFocus ())
Let rWinClass = GetWindowClass (rWin)
If (rWinClass != wcOscarBuddyListWin) then
	If (IsWindowVisible (hToolBar) == TRUE) then
		SaveCursor ()
		InvisibleCursor ()
	;	MoveToWindow (hToolBar)
		MoveTo (GetWindowLeft (hToolBar), GetWindowTop (hToolBar))
		While (GetWindowClass (GetCurrentWindow ()) == wcCBClass && FindNextAttribute (ATTRIB_GRAPHIC))
			Let strButtonName = GetWord ()
			If (strButtonName != msgCorner
				&& strButtonName != msgScroll) then
				Let strButtonList = strButtonList + strButtonName + "\007"
			EndIf
		EndWhile
		RestoreCursor ()
		Return strButtonList
	Else
		Return ""
	EndIf
Else
	If (IsWindowVisible (rWin) == TRUE) then
		SaveCursor ()
		InvisibleCursor ()
		MoveTo (GetWindowLeft (rWin), GetWindowTop (rWin))
		While (FindNextAttribute (ATTRIB_GRAPHIC))
			Let strButtonName = GetWord ()
			If (StringContains (strButtonName , msgSymbols) == FALSE) then
				Let strButtonList = strButtonList + strButtonName + "\007"
			EndIf
		EndWhile
		RestoreCursor ()
		Return strButtonList
	Else
		Return ""
	EndIf
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Function ClickToolBarButton (handle winHandle, string buttonLabel)
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to click the tool bar button specified in the tool 
;	bar button list.
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:	
;	String
;		List indicating the tool bar buttons that are actually available
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/29/1999		Ben Key
;	Function created
;*****************************************************************************************************************
Function ClickToolBarButton (handle winHandle, string buttonLabel)
Var  
	Handle rWin, String rWinTitle, 
	String rWinClass, Handle hTarget
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let rWinClass = GetWindowClass (rWin)
If (rWinClass == wcOscarBuddyListWin) then
	SaveCursor ()
	JawsCursor ()
	If (FindGraphic (rWin, buttonLabel, s_top, s_unrestricted)) then
		pause ()
		LeftMouseButton ()
	else
		Say(buttonLabel + msgToolNotFound, ot_control_name)
	EndIf
	RestoreCursor ()
ElIf (StringContains (rWinTitle, wnProfileExtendedInfo)) then
	If (buttonLabel == wnBack && StringContains (buttonLabel, msgBackground) == FALSE) then
		Let hTarget = FindDescendantWindow (rWin, cID_Back)
	ElIf (buttonLabel == wnFinish) then
		Let hTarget = FindDescendantWindow (rWin, cID_Finish)
	ElIf (buttonLabel == wnCancel) then
		Let hTarget = FindDescendantWindow (rWin, cID_Cancel)
	EndIf
	If (hTarget != 0) then
		SaveCursor ()
		JAWSCursor ()
		MoveToWindow (hTarget)
		pause ()
		LeftMouseButton ()
		RestoreCursor ()
	Else 
		If (buttonLabel == wnBack && StringContains (buttonLabel, msgBackground) == FALSE
			|| buttonLabel == wnFinish
			|| buttonLabel == wnCancel) then
			Say (buttonLabel + " " + msgButton + " " + msgToolNotFound, ot_status)
		Else
			SaveCursor ()
			JawsCursor ()
			If (FindGraphic (winHandle, buttonLabel, s_top, s_unrestricted)) then
				pause ()
				LeftMouseButton ()
			else
				Say(buttonLabel + msgToolNotFound, ot_control_name)
			EndIf
			RestoreCursor ()
		EndIf
	EndIf
	Return
Else
	SaveCursor ()
	JawsCursor ()
	If (FindGraphic (winHandle, buttonLabel, s_top, s_unrestricted)) then
		pause ()
		LeftMouseButton ()
	else
		Say(buttonLabel + msgToolNotFound, ot_control_name)
	EndIf
	RestoreCursor ()
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function ReadOverviewWindows ()
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to control the reading of the various dialog boxes 
;	that make up the "New User Wizard."
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/28/1999		Ben Key
;	Function created
;*****************************************************************************************************************
Void Function ReadNewUserWizardWindows ()
Var String rWinTitle, Handle rWin, Handle hTarget, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnWelcome)) then
	Let WindowSpoken = 1
; In the real windows titled "Welcome!" there are three static windows that 
; need to be spoken.  Each window has a control ID of 65535.  In addition, 
; these windows do not appear in the window hierarchy in the same order 
; in which they appear visibly.  The bottom most window is first, followed by 
; the top window and the middle window.  The three windows do follow 
; one another in the windows hierarchy.

	; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
	; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Read the first static window found
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
	;  Say the current control and return
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strProfile)) then
	Let WindowSpoken = 1
; In the real window titled "AOL Instant Messenger Overview - - My Profile," 
; there are 2 visible static windows, and one hidden static window, each 
; with a control ID of 65535.  Fortunately, these are listed in the window 
; hierarchy in the same order in which they appear visibly.  Use 
; FindDescendantWindow (...) to obtain the first of these windows and
; then walk through the window hierarchy reading the remaining windows
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	While (GetControlID (hTarget) == cID_WelcomeStatic)
		If (IsWindowVisible (hTarget)) then 
			SayWindow (hTarget, READ_EVERYTHING)
		EndIf
		Let hTarget = GetNextWindow (hTarget)
	EndWhile
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnAIMOverviewNow)) then
	Let WindowSpoken = 1
; In the real window titled "Set Up AOL Instant Messenger Now!" there 
; are 2 visible static windows, and one hidden static window, each with 
; a control ID of 65535.  Fortunately, these are listed in the window hierarchy 
; in the same order in which they appear visibly.  Use FindDescendantWindow (...) 
; to obtain the first of these windows an then walk through the window 
; hierarchy reading the remaining windows
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	While (GetControlID (hTarget) == cID_WelcomeStatic)
		If (IsWindowVisible (hTarget)) then 
			SayWindow (hTarget, READ_EVERYTHING)
		EndIf
		Let hTarget = GetNextWindow (hTarget)
	EndWhile
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strNeighborhood)) then
	Let WindowSpoken = 1
; In the real window titled "AOL Instant Messenger Overview - Buddy 
; Controls," there are seven static windows, each with a control ID of 
; 65535.  Fortunately, these are listed in the window hierarchy in the 
;	same order in which they appear visibly.  Use 
;	FindDescendantWindow (...) to obtain the first of these windows an 
; then walk through the window hierarchy reading the remaining 
; windows
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	While (GetControlID (hTarget) == cID_WelcomeStatic)
		SayWindow (hTarget, READ_EVERYTHING)
		Let hTarget = GetNextWindow (hTarget)
	EndWhile
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnAIMOverview) == TRUE 
	&& StringContains (rWinTitle, strBuddyList) == FALSE 
	&& StringContains (rWinTitle, strBuddyControls) == FALSE
	&& StringContains (rWinTitle, strProfile) == FALSE
	&& StringContains (rWinTitle, strSetUp) == FALSE) then
	Let WindowSpoken = 1
; In the real window titled "AOL Instant Messenger Overview," there are three 
; static windows that need to be spoken.  Each window has a control ID of 65535. 
; In addition, these windows do not appear in the window hierarchy in the same 
; order in which they appear visibly.  The bottom most window is first, followed 
; by the top window and the middle window.  The three windows do follow one 
; another in the windows hierarchy.
; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
; Read the first static window found
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
;  Say the current control and return
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strBuddyList)) then
	Let WindowSpoken = 1
;  In the real window titled "AOL Instant Messenger Overview - Buddy List," 
; there are three static windows that need to be spoken.  Each window has 
; a control ID of 65535. In addition, these windows do not appear in the 
; window hierarchy in the same order in which they appear visibly.  The 
; bottom most window is first, followed by the top window and the middle 
; window.  The three windows do follow one another in the windows 
; hierarchy.
; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
; Get the window handle of the next window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
; Read the first static window found
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
;  Say the current control and return
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strBuddyControls)) then
	Let WindowSpoken = 1
; In the real window titled "AOL Instant Messenger Overview - Buddy Controls," 
; there are seven static windows, each with a control ID of 65535.  Fortunately, 
; these are listed in the window hierarchy in the same order in which they 
; appear visibly.  Use FindDescendantWindow (...) to obtain the first of these 
; windows an then walk through the window hierarchy reading the remaining 
; windows
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	While (GetControlID (hTarget) == cID_WelcomeStatic)
		SayWindow (hTarget, READ_EVERYTHING)
		Let hTarget = GetNextWindow (hTarget)
	EndWhile
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function ReadProfileWizardWindows ()
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to control the reading of the various dialog 
;	boxes that make up the User Profile Wizard.
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/28/1999		Ben Key
;		Function created
;*****************************************************************************************************************
Void Function ReadProfileWizardWindows ()
Var String rWinTitle, Handle rWin, Handle hTarget, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, strCreateProfileTips)) then
	Let WindowSpoken = 1
; In the real window titled "Create a Profile - Directory Profile Tips", there is 
; one static window that needs to be spoken.  Use FindDescendantWindow (...) 
; to obtain the window handle and SayWindow (...) to read it.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strProfileMoreInfo)) then
	Let WindowSpoken = 1
; In the real window titled "Create a Profile - More Info Profile Tips" there 
; are five static windows that need to be spoken.  Each window has a 
; control ID of 65535.  In addition, these windows do not appear in the window 
; hierarchy in the same order in which  they appear visibly.  The second 
; window is first, followed by the top window and the remaining windows 
; in the order they appear.  The three windows do follow one another in 
; the windows hierarchy.
	; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
	; Get the window handle of the second window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Read the first static window found
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
	; Get the window handle of the third window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Get the window handle of the fourth window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Get the window handle of the fifth window in the window hierarchy and read it
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	;  Say the current control and return
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnProfileWarning)) then
	Let WindowSpoken = 1
; In the real window titled "AOL Instant Messenger (SM)", there is one static window 
; that needs to be spoken.  Use FindDescendantWindow (...) to obtain the window 
; handle and SayWindow (...) to read it.
	Let hTarget = FindDescendantWindow (rWin, cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnProfileDirectory)) then
	Let WindowSpoken = 1
; In the real window titled "Create a Profile - Searchable Directory", there is one 
; static window that needs to be spoken.  Use FindDescendantWindow (...) to obtain 
; the window handle and SayWindow (...) to read it.
	Let hTarget = FindDescendantWindow (rWin, cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayFocusedWindow ()
	Return
ElIf (StringContains (rWinTitle, strProfileChat)) then
	Let WindowSpoken = 1
; In the real window titled "Create a Profile - Chat Interests", there is one static 
; window that needs to be spoken.  FindDescendantWindow (...) fails to obtain 
; the window handle.  Instead, use FindString (...) to search for a string particular 
; to the window and then use GetCurrentWindow () to obtain the window handle.  
; Then use SayWindow (...) to read it.
	SaveCursor ()
	InvisibleCursor ()
	If (FindString (rWin, strDirEntry, S_TOP, S_RESTRICTED)) then 
		Let hTarget =GetCurrentWindow ()
	EndIf
	RestoreCursor ()
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnProfileExtendedInfo)) then
	Let WindowSpoken = 1
; In the real window titled "Create a Profile - More Info", there are two static 
; windows that needsto be spoken.  Use FindDescendantWindow (...) to obtain 
; the first window handle and SayWindow (...) to read it.  Then, since the second 
; static window is next in the window hierarchy, use GetNextWindow () to obtain 
; the next window handle and use SayWindow (...) to read it
	Let hTarget = FindDescendantWindow (rWin, cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	SayFocusedWindow ()
	Return
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function ReadAddBuddyWizardWindows ()
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to control the reading of the various dialog 
;	boxes that make up the Add Buddy Wizard.
;Parameters:
;		None
;Globals
;	Used:				
;	Modified:		
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/28/1999		Ben Key
;		Function created
;*****************************************************************************************************************
Void Function ReadAddBuddyWizardWindows ()
Var String rWinTitle, Handle rWin, Handle hTarget, Handle hTemp, Int nCount
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnAddABuddyComplete)) then
	Let WindowSpoken = 1
;	In the real window titled "Add a Buddy Complete," there are 7 static windows that 
; need to be read automatically.  The windows follow each other in the window 
; hierarchy, but not in the order	in which they need to be read.  5 of the windows do 
; not change from one time the window is displayed to the next.  They each have a 
; control ID of 65535.  Two of the windows vary according to the buddy you just added.  
; They have the following control ID's:  406 and 164.  In order to read the windows in a 
; logical order as they are displayed, read them as follows: 1, 2, 6 
; (control ID 406, 3, 7 (control ID 164), 4, and 5.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTemp = FindDescendantWindow (GetFirstChild (rWin), cID_wnAddABuddyCompleteBuddy)
	SayWindow (hTemp, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTemp = FindDescendantWindow (GetFirstChild (rWin), cID_wnAddABuddyCompleteGroup)
	SayWindow (hTemp, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnAddBuddy)) then
	Let WindowSpoken = 1
;	In the real window titled "Add A Buddy" there are three static windows that 
; need to be spoken.  Each window has a control ID of 65535. In addition, these 
; windows do not appear in the window hierarchy in the same order in which 
; they appear visibly.  The top most static window is in the 	window hierarchy 
; second.  It is preceeded by the second window from the top.  The screen name
;	edit box and its label (which is a static window) come between the top 
; window and the bottom most static window
	; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
	; Get the window handle of the next window in the window hierarchy and read it, this is the
	; top most window
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Read the window whose handle is stored in hTemp, this is the second window.
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
	; Get the window handle of the last static window and read it
	Let hTemp = GetNextWindow (hTarget)
	Let  nCount = 0
	While (StringContains (GetWindowText (hTemp, FALSE), strAddBuddyStatic) == 0 && nCount < 5)
		Let hTemp = GetNextWindow (hTemp)
		Let nCount = nCount + 1
	EndWhile
	SayWindow (hTemp, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnFBByAddress)) then
	Let WindowSpoken = 1
; In the window tited "Find a Buddy By Name and Address" there is one static 
; window with a control ID of 65535
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnFBByInterest)) then
	Let WindowSpoken = 1
; In the window tited "Find a Buddy By Common Interests" there are two static windows 
; with a control ID of 65535.  The second window is identified by the string To edit your 
; own Directory entry, click the 'Edit My Directory Entry' button.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SaveCursor ()
	InvisibleCursor ()
	If (FindString (rWin, strToEditOwnDirEntry, S_TOP, S_UNRESTRICTED)) then
		Say (GetLine (), ot_message)
	EndIf
	RestoreCursor ()
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnFindBuddyFailure)) then
	Let WindowSpoken = 1
; In the window tited "Find a Buddy - Failure" there are two static windows with a 
; control ID of 65535.  They are in the same order in the window hierarchy as they 
; appear visually.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, strFBByEmail)) then
	Let WindowSpoken = 1
;There are two real windows in a row titled "Find a Buddy by E-mail Address."  In the 
; first there are four static windows that need to be spoken.  Each window has a 
; control ID of 65535. In addition, these windows do not appear in the window 
;	hierarchy in the same order in which they appear visibly.  The top most static window 
; is in the window hierarchy first.  It is followed by the the bottom most static window.  
; Several windows come between this window and the third static window from the top.  
; Then is the controls button which is followed by the second static window.
; 	In the second window, there are only two static windows.  The top most static window 
; is first in the window hierarchy.  The second static window is seperated from the first 
; by the AIM image logo window.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
; Find the string "You can also enter a person's e-mail address" within the real window and 
; get the window handle of the static window containing the text.  Then say the window.  
; Then continue processing for this real window.  It is the first real window that has this title.
	SaveCursor ()
	InvisibleCursor ()
	If (FindString (rWin, strFBE_Static1, S_TOP, S_UNRESTRICTED)) then
		Let hTarget = GetCurrentWindow ()
		SayWindow (hTarget, READ_EVERYTHING)
; Find the string "An example of an e-mail address" within the real window and 
; get the window handle of the static window containing the text.  Then say the window
		If (FindString (rWin, strFBE_Static2, S_TOP, S_UNRESTRICTED)) then
			Let hTarget = GetCurrentWindow ()
			SayWindow (hTarget, READ_EVERYTHING)
		EndIf
; Find the string "Click the Next button to continue" within the real window and get the 
; window handle of the static window containing the text.  Then say the window
		If (FindString (rWin, strFBE_Static3, S_TOP, S_UNRESTRICTED)) then
			Let hTarget = GetCurrentWindow ()
			SayWindow (hTarget, READ_EVERYTHING)
		EndIf
		RestoreCursor ()
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	Else
		Let hTarget = GetNextWindow (GetNextWindow (hTarget))
		SayWindow (hTarget, READ_EVERYTHING)
		RestoreCursor ()
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	EndIf	
	Return
ElIf (StringContains (rWinTitle, wnFindBuddy)) then
	Let WindowSpoken = 1
;	In the real window titled "Find A Buddy" there are two static windows that need 
; to be spoken.  Both windows have a control ID of 65535.  In addition, these windows 
; do not appear in the window hierarchy in the same order in which they appear visibly.  
; The top most static window is in the 	window hierarchy second.  It is preceeded by 
; the second window from the top.  
	; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		Let hTemp = hTarget
	EndIf
	; Get the window handle of the next window in the window hierarchy and read it, 
	; this is the top most window
	Let hTarget = GetNextWindow (hTarget)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Read the window whose handle is stored in hTemp, this is the second window.
	If (hTemp) then SayWindow (hTemp, READ_EVERYTHING) EndIf
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnSignOnFriend)) then
	Let WindowSpoken = 1
;	There are two real windows in a row titled ""Sign on a Friend Today!".  In the first real 
; window titled 	"Sign on a Friend Today!" there are two static windows that need 
; to be spoken.  Both windows have a control ID of 65535.  In addition, these windows 
; do not appear in the window hierarchy in the same order in which they appear visibly.  
; The top most static window is in the 	window hierarchy first.  It is followed by two static 
; windows that serve as the labels for two edit boxes which are in turn followed by the second 
; static box that needs to be spoken.
; In the second window, there are five static windows.  In this window, the static windows 
; appear in the same order in the window hierarchy as they do visually.
	; Get the first static window handle and store it for later use
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	If (hTarget) then 
		SayWindow (hTarget, READ_EVERYTHING)
	EndIf
	; Find the string "As soon as your friend has registered" and get the window handle of the
	; static window that contains it.  Then read the window.  If the string is found, it is the first
	; real window titled "Sign on a Friend Today."  Otherwise, read the next four windows.
	SaveCursor ()
	InvisibleCursor ()
	If (FindString (rWin, strSignOnStatic, S_TOP, S_UNRESTRICTED)) then
		Let hTarget = GetCurrentWindow ()
		SayWindow (hTarget, READ_EVERYTHING)
		SayFocusedWindow ()
		Return
	Else
		RestoreCursor ()
		Let hTemp = GetNextWindow (hTarget)
		SayWindow (hTemp, READ_EVERYTHING)
		SaveCursor ()
		InvisibleCursor ()
		If (FindString (rWin, strSignOnStaticA, S_TOP, S_UNRESTRICTED)) then
			Let hTarget = GetCurrentWindow ()
			Say (GetLine (), ot_message)
			Let nCount = 0
			Let hTemp = hTarget
			While (nCount < 2)
				Let hTemp = GetNextWindow (hTemp)
				SayWindow (hTemp, READ_EVERYTHING)
				Let nCount = nCount + 1
			EndWhile
		EndIf
	EndIf	
	RestoreCursor ()
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnLookupReply)) then
	Let WindowSpoken = 1
	; If the user was not found, there is one static window in the window titled "Lookup 
	; Reply List" with a control ID of 617.
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_LookUpStatic)
	If (hTarget) then 
		SayWindow (hTarget, READ_EVERYTHING)
	Else 
		Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
		If (hTarget) then
			SayWindow (hTarget, READ_EVERYTHING)
		EndIf
	EndIf
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnAddBuddyA)) then
	Let WindowSpoken = 1
	Let hTarget = FindDescendantWindow (rWin, cID_AddBuddyAStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
ElIf (StringContains (rWinTitle, wnSearchFunctionality)) then
	Let WindowSpoken = 1
	Let hTarget = FindDescendantWindow (GetFirstChild (rWin), cID_WelcomeStatic)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
EndIf
EndFunction

Void Function ReadMiscWindows ()
Var String rWinTitle, Handle rWin, Handle hTarget, Handle hTemp, Int nCount
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnBuddyFound)) then
	Let hTarget = FindDescendantWindow (rWin, cID_NewUserA)
	SayWindow (hTarget, READ_EVERYTHING)
	Let nCount = 0
	Let hTemp = GetNextWindow (hTarget)
	While (nCount < 3 && hTemp != 0)
		SayWindow (hTemp, READ_EVERYTHING)
		Let hTemp = GetNextWindow (hTemp)
		Let nCount = nCount + 1
	EndWhile
EndIf
EndFunction

Void Function ReadOscresWindows (handle rWin, string rWinTitle)
Var String curWinName, Handle hTemp, String strTemp, Handle curWin, Handle hTarget
;Let rWin = GetRealWindow (GetCurrentWindow ())
;Let rWinTitle = GetWindowName (rWin)
;	The following windows are a part of oscres.dll.  However, these windows are activated 
; as a result of menu items in aim.exe and when they are first activated, JFW has not yet 
; loaded oscress.jsb.  Aim.jsb is still loaded.  Therefore control the speaking of these 
; windows on activation here.
;	1.		"New User Registration",
;	2.		"Sign On",
;	3.		"Save Buddy List",
;	4.		"Change Password",
;	5.		"Format Screen Name",
;	6.		"Update E-mail Address",
;	7.		"Check the items you would like to save below",
Say (rWinTitle, ot_message)
Say (msgDialog, ot_message)
; Customize the speaking of the New User Registration window so that the static text window 
; that appears above the Register New Sreen Name button gets spoken automatically.  Also 
; applies to Save Buddy List dialog and the Update E-mail Address dialog
If ((rWinTitle == wnNewUserReg)
	|| (rWinTitle == wnSaveList)
	|| (rWinTitle == wnUpdateEmail)) then
	; The first child window of the real window has a window class of #32770.  The static 
	; window of interest is a descendant  window of this window.  It has a control ID of 65535.  
	; Use FindDescendantWindow to find its window handle and use SayWindow to read its 
	; contents.  Then speak the name of the active control.
	Let hTarget = FindDescendantWindow (rWin, cID_NewUserA)
	If (hTarget) then 
		SayWindow (hTarget, READ_EVERYTHING) 
	EndIf
	If (rWinTitle == wnSaveList && GetCurrentControlID () == cID_CheckItemsToSave) then
		Say (wnCheckItemsToSave, ot_message)
	Else
		SayWindowTypeAndText (GetCurrentWindow ())
	EndIf
	Return
;	Customize speaking of the Change Password dialog.  The first child window of the real 
; window has a window class of #32770.  All the dialog box controls are child windows of 
; this window.  The dialog box is composed of three edit boxes, each with a static text 
; window containing its label.  All the static text windows have the same control ID, 65535.	
; The static text window that needs to be spoken automatically can be identified by the string 
; "To change your password."	Use FindDescendantWindow (...) to find the first static window, 
; and then walk through the window hierarchy until finding a window that contains the 
; appropriate string.  Then speak the window followed by the active control.
ElIf (rWinTitle == wnChangePassword) then
	Let hTemp = FindDescendantWindow (rWin, cID_NewUserA)
	If (hTemp) then
		While (StringContains (GetWindowText (hTemp, FALSE), strToChangePassword) == 0 && hTemp != 0)
			Let hTemp = GetNextWindow (hTemp)
		EndWhile
		SayWindow (hTemp, READ_EVERYTHING)
		SayWindowTypeAndText (GlobalFocusWindow)
	Else
		SayWindowTypeAndText (GlobalFocusWindow)
	EndIf
	Return
;	Customize speaking of the Format Screen Name dialog.  The first child window of the 
; real window has a window class of #32770.	All the dialog box controls are child 
; windows of this window.  The dialog box is composed of one edit box, two buttons, and 
; two static text windows.  The first static text window is the label for the edit box.  The 
; second static window ( the one that needs to be spoken automatically) is seperated from 
; the first by several controls,	Use FindDescendantWindow (...) to find the first static window, 
; and then walk through the window hierarchy until finding the second static window.  Then 
; speak the window followed by the active control.
ElIf (rWinTitle == wnFormatScreenName) then
	Let hTemp = FindDescendantWindow (rWin, cID_NewUserA)
	Let hTemp = GetNextWindow (hTemp)
	If (hTemp) then
		While (GetControlID (hTemp) != cID_NewUserA && hTemp != 0)
			Let hTemp = GetNextWindow (hTemp)
		EndWhile
		SayWindow (hTemp, READ_EVERYTHING)
		SayWindowTypeAndText (GlobalFocusWindow)
	Else
		SayWindowTypeAndText (GlobalFocusWindow) 
	EndIf
	Return
EndIf
EndFunction

Int Function IsIAmAwayDialog ()
Var 
	Handle rWin, Handle hFirstChild, Handle hNext, Handle hTest, 
	String rWinClass, Int nFirstChildID, Int nNextID, String strTestName
Let rWin = GetRealWindow (GetFocus ())
Let hFirstChild = GetFirstChild (rWin)
Let hNext = GetNextWindow (hFirstChild)
Let hTest = FindDescendantWindow (rWin, cID_IMBack)
Let rWinClass = GetWindowClass (rWin)
Let nFirstChildID = GetControlID (hFirstChild)
Let nNextID = GetControlID (hNext)
Let strTestName = GetWindowName (hTest)
If (rWinClass == wcDialog) then
	If ((nFirstChildID == cID_IMAway1)
		&& (nNextID == cID_IMAway2)
		&& (strTestName == wnIMBack)) then
		Return 1
	Else
		Return 0
	EndIf
Else
	Return 0
EndIf
EndFunction

Int Function IsEditPreferencesDialog ()
; The window title of the edit preferences dialog changes to indicate the active dialog box 
; page name. Therefore, it would not be efficient to base the decision of whether or not the 
; active real window is the edit preferences dialog.  Since the only known window of 
; oscarui.jss is the edit preferences dialog, one could assume that the real window is the edit 
; preferences dialog simply because oscarui.dll is the active application.  However, the fact 
; that the edit preferences dialog is the only known window does not mean that it is the only 
; window.  Therefore, the window structure of the real window is used to confirm that the 
; window is the edit preferences dialog.
;	The edit preferences dialog has the following unique window structure:
;		The window class of the real window is #32770.
;		The first child window of the real window is #32770.
;		The next window after the first child window in the window hierarchy has a window 
;			class of _Oscar_TabCtrl.
Var String rWinTitle, Handle rWin, String rWinClass, 
	Handle rWinFirstChild, Handle hTarget, String hTargetClass
Let rWin = GetRealWindow (GetFocus())
Let rWinClass = GetWindowClass (rWin)
Let rWinTitle = GetWindowName (rWin)
Let rWinFirstChild = GetFirstChild (rWin)
Let hTarget = GetNextWindow (rWinFirstChild)
Let hTargetClass = GetWindowClass (hTarget)
If (rWinClass == wcDialog && hTargetClass == wcOscarTabControl) then
	Return 1
Else
	Return 0
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Int Function DidControlChange ()
;Author's Name:
;		Ben Key
;Description:
;	This function is used to detect if the active control in a dialog box has changed.  
;	This function first stores the previous values of various golbal variables into 
;	tempory varibles before changing them so that they can be used for comparison.  
;	This function then determines if the current real window is a dialog box or a window 
;	that  is specified to be treated as a dialog box.  Next the function stores the current 
;	window handle in the global variable cwHandle.  It then stores the pixel coordinates 
;	of the left and top edges of the current control into the global variables cwLeft and 
;	cwTop.  Then, if the current control is a button, the button label is stored in the global 
;	variable cwButtonLabel.   The function then compares the current values	with the previous 
;	values.  If they have changed, the function returns 1, otherwise it returns 0.
;Parameters:
;		None
;Globals
;	Used:	
;		Handle cwHandle, Int cwLeft, 	Int cwTop, 
;		String cwButtonLabel, GlobalPrevRealName
;	Modified:
;		Handle cwHandle, Int cwLeft, 	
;		Int cwTop, String cwButtonLabel
;Return Value:		Int
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;					                          MODIFICATION LOG
;06/23/1999		Ben Key
;	Function created
;06/28/1999		Ben Key					
;		Function modified so that it always returns 0 if a change in 
;		window title is detected
;*****************************************************************************************************************
Int Function DidControlChange ()
Var Handle rWin, String rWinTitle, Handle prevWinHandle, Int pwTop, 
	Int pwLeft, String pwButtonLabel, Handle prevFirstChild
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let prevWinHandle = cwHandle
Let cwHandle = GetCurrentWindow ()
Let pwLeft = cwLeft  Let pwTop = cwTop
Let cwTop = GetWindowTop (cwHandle)
Let cwLeft = GetWindowLeft (cwHandle)
Let pwButtonLabel = cwButtonLabel
Let cwButtonLabel = GetWord ()
Let prevFirstChild = FirstChild
Let FirstChild = GetFirstChild (rWin)
If ((GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)	; The real window is a dialog box
    || (DialogActive () == ACTIVE)) then		; the function DialogActive returns true
	; If the window title changed, always return 0
	If (StringContains (GlobalPrevRealName, rWinTitle) == 0) then 
		Return 0
; Sometimes it is possible that the real window handle and the real window title did not 
;	change, just the contents of the dialog changed. In this case, the first child window of 
; the dialog box usually changes.  Then return 0
	ElIf (FirstChild != prevFirstChild) then 
		return 0
	; If the location of the current window changed return 1
	ElIf (cwTop != pwTop || cwLeft != pwLeft) then 
		Return 1 
	; If the current window is a button, return 1 if there was a change in button label
	ElIf (GetWindowSubtypeCode (GetCurrentWindow ()) == WT_BUTTON) then
		If (cwButtonLabel != pwButtonLabel) then 
			Return 1 
		EndIf
	; If the window handle of the current window has changed return 1
	ElIf (cwHandle != prevWinHandle) then 
		Return 1 
	EndIf
; Always return 0 if the current window is not a dialog box
Else 
	Return 0 
EndIf
EndFunction

; ***/  All other event functions and related functions
;*****************************************************************************************************************
;Function:	
;		Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
;Author's Name:
;		Ben Key
;Description:
;	This function is used to customize how JFW reads certain windows encountered in 
;	AOL Instant Messenger when the focus changes.  
;	Most of the customizations to FocusChangedEvent pertain to the series of dialog boxes 
;	that make up the New User Wizard.  The New User Wizard is composed of a series of
;	dialog boxes that have the same real window handle, the same buttons, and the same 
;	basic configuration.  The dialog boxes are not seperate dialog boxes displayed one after
;	another as much as they are the same dialog box redrawn to display different text and 
; 	occasionally different controls.
;	When moving from one dialog box to the next (by pressing the next or back buttons),
;	for most of the dialogs, there is no change in the active control, the current window handle,
; 	or position.  Because of this, FocusChangedEvent (...) is not called when switcing between 
;	dialog boxes.  Therefore, the reading of the dialog box contents when switching between 
;	dialog boxes is for the most part controled by SayNonHighlightedText (...).
;	However, SayNonHighlightedText (...) is not called when switching from another application
;	to AIM when one of these dialog boxes is active.  Therefore, it is necessary to make it possible 
;	for FocusChangedEvent (...) to control the speaking of these dialog boxes.  It is also 
;	necessary to allow FocusChangedEvent (...) to control speaking of the active control when 
;	moving between controls of a dialog box.  To complicate matters further, there are two 
;	dialog boxes for which FocusChangedEvent (...) is always called, and two other dialog 
;	boxes for which FocusChangedEvent (...) is called if moving between the dialog boxes in 
;	a particular direction.  The first If statement in FocusChangedEvent (...) is used to control
;	the various possibilities that are encountered in navigating these dialog boxes
; 	and to prevent conflicts with SayNonHighlightedText (...)
;
;	Another group of windows handled in FocusChangedEvent is the User Profile Wizard 
;	dialog group they are simular in nature to the New User Wizard and thus are handled 
;	in a simular mannner
;Parameters:
;		handle FocusWindow			The handle of the window that currently has focus
;		handle	PrevWindow				The handle of the window that previously had focus
;Globals
;	Used:	
;		GlobalPrevReal, GlobalPrevRealName, 
;		GlobalPrevApp, GlobalPrevFocus, nFocusChanged
;	Modified:
;		GlobalPrevReal, GlobalPrevRealName, 
;		GlobalPrevApp, GlobalPrevFocus, nFocusChanged
;	Return Value:
;		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
;06/23/1999		Ben Key
;		Project started
;06/28/1999		Ben Key
;		FocusChangedEvent (...) was rewritten to simply do nothing if the Focus Change Occured 
;		in one of the overview windows.  All speaking of these windows is now controled by 
;		SayNonHighlightedText (...), FocusPointMovedEvent (...), and ReadOverViewWindows ().
;06/28/1999		Ben Key
;		Previous strategy was abandoned.  A new strategy was developed (documented above) 
;		that incorporated tighter control over the interraction between SayNonHighlightedText (...) 
;		and FocusChangedEvent (...) and more returns from DidControlChange ().
;06/29/1999		Ben Key
;		The strategy that was created yesterday to handle speaking of the New User Wizard 
;		windows was applied to the User Profile Wizard Windows
;*****************************************************************************************************************
Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var handle RealWindow, string RealWindowName, handle AppWindow,
	Int nDidChange, Int cwTypeCode, String curWinName, Handle hTarget,
	Int rWinLen, Int FCLen
Let rWinLen = StringLength (GetWindowClass (GetRealWindow (GetFocus ())))
Let FCLen = StringLength (GetWindowClass (GetFirstChild (GetRealWindow (GetFocus ()))))
If (rWinLen == iBuddyChatParentLen
	&& FCLen == iBuddyChatChildLen) Then
	Say (GetWindowName (GetRealWindow (GetFocus ())), ot_control_name)
	Say (GetWindowName (GetCurrentWindow ()), ot_control_name)
	Say (msgButton, ot_control_name)
	SwitchToScriptFile ("Wndutils.jsb", "")
	Return
EndIf
If (nSuppressEcho == TRUE) then Return EndIf
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
let GlobalFocusWindow = FocusWindow
; Get the Window Sub Type Code of the current window
Let cwTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
; Get the Window name of the current window
Let curWinName = GetWindowName (GetCurrentWindow ())
;	The following block of code, labeled "Oscres Code Block" is designed to cause windows 
; that are a part of oscres.dll but are reached by selecting menu items in Aim.exe to speak 
; properly when they are created.  When the windows are created, Aim.jsb is still loaded in 
; memory and by the time JFW unloads Aim.jsb and loads Oscres.jsb JFW has already 
; processed the FocusChangedEvent that occured when the window was created.  Thus it is 
; necessary to handle the initial speaking of these windows here.
;*** Begin Oscres Code Block
;If ((RealWindowName == wnSignOn)
If ((StringContains (RealWindowName, wnSignOn) && StringContains (RealWindowName, wnSignOnFriend) == FALSE)
	|| (RealWindowName == wnSaveList)
	|| (RealWindowName == wnChangePassword)
	|| (RealWindowName == wnFormatScreenName)
	|| (RealWindowName == wnUpdateEmail)) then
	ReadOscresWindows (RealWindow, RealWindowName)
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
EndIf
;*** End Oscres Code Block
;	*** Begin Oscarui.jss code block
;	When the user selects Edit Preferences Dialog from the My Options submenu of the File menu,
; the Sounds Page of the Edit Preferences Dialog box is opened.  The Edit Preferences Dialog
;	is a seperate executable (oscarui.dll), but when the dialog box first appears after the
;	Edit Preferences Dialog menu item is selected, JFW has not yet loaded the oscarui.jsb script
;	file.  Therefore the initial focus change event that occurs when the dialog box is activated
;	must be processed here to cause the dialog box to speak properly.
If (IsEditPreferencesDialog ()) then
	; Say Edit Preferences Dialog
	Say (msgDialogName, ot_message)
	; Say the active page name
	Say (GetActivePageName () + strSpace + msgPage, ot_message)
	SayWindowTypeAndText (GetCurrentWindow ())
	Let nAppChanged = 1
	Return
EndIf
;	*** End Oscarui.jss code block
; Control speaking when the I'm Away Message is first activated or moved to from another 
; application
If (IsIAmAwayDialog () && StringContains (RealWindowName, GlobalPrevRealName) == FALSE) then
	Say (RealWindowName, ot_control_name)
	Say (msgIMAway, ot_control_name)
	Say (GetWindowType (RealWindow), ot_message)
	Let hTarget = FindDescendantWindow (RealWindow, cID_IMAway3)
	SayWindow (hTarget, READ_EVERYTHING)
	SayFocusedWindow ()
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
EndIf
; The following block of code, labeled "Wizard Code Block" is designed to control the reading 
; of three groups of windows, the New User Wizard windows, the Add Buddy Wizard windows, 
; and the Profile Wizard windows.  In each of these groups of dialog boxes, 
; FocusChangedEvent is not called reliably when switching from one dialog to another by way 
; of the back or next buttons.  Therefore much of the reading of these windows when switching 
; from one to the next is handled by SayNonHighlightedText (...).  However, there are 
; ocasions in these dialog boxes when FocusChangedEvent (...) is called when switching 
; between dialog boxes.  In addition, SayNonHighlightedText (...) is not called when switching 
; from another application to one of these windows.  Therefore FocusChangedEvent (...) needs 
; to have the capability of causing JFW to read these windows.  Much of the logic in this block 
; of code is used to prevent conflicts between FocusChangedEvent (...) and 
; SayNonHighl\lightedText (...).  A function that is used extensivily in this block of code is 
; DidControlChange ().  It is used to assist in the decision of whether a new dialog has been 
; created or if the user is simply moving between the controls of the dialog box.  If a new 
; dialog box has been created, the entire dialog box needs to be read followed by the active
; control.  Otherwise, only the active control needs to be read.  DidControlChange () is only 
; called from FocusChangedEvent.  One of the factors it uses to determine if the user is tabbing 
; between controls or moving between dialog boxes is a change in window title.  If the
; window title changes, DidControlChange () always returns 0.  However, for most of the dialog 
; boxes, FocusChangedEvent (...) (and thus DidControlChange ()) is not called when switching 
; between dialog boxes.  Therefore, the first time the user presses tab or shift tab to move 
; between controls in that dialog box, DidControlChange ()	inaccurately returns 0.  In order to 
; make a more accurate assessment of whether the dialog box changed or the user was 
; tabbing between controls, the name of the active control is analyzed to determine if it does 
; not match the name of the control that is active when switching between dialogs.  If it does 
; not match, the active control is spoken, otherwise the dialog is spoken followed by the active 
; control In each of the windows, if FocusChangedEvent (...) controled the speaking of the 
; dialog, the global variable nFocusChanged is set to	1 to prevent conflicts with 
; SayNonHighlightedText (...) (it checks this value to determine if the window has already 
; been spoken.
;*** Begin Wizard Code Block
; Always say the entire dialog box if switching from another application or a
;	window that is outside of the wizard window group
If (StringContains (GlobalPrevRealName, wnWelcome) == FALSE
	&& StringContains (GlobalPrevRealName, wnSignOnFriend) == FALSE
	&& StringContains (GlobalPrevRealName, wnAIMOverview) == FALSE
	&& StringContains (GlobalPrevRealName, strSetup) == FALSE
	&& StringContains (GlobalPrevRealName, wnCreateProfileTips) == FALSE
	&& StringContains (GlobalPrevRealName, wnProfileMoreInfo) == FALSE
	&& StringContains (GlobalPrevRealName, wnProfileDirectory) == FALSE
	&& StringContains (GlobalPrevRealName, wnProfileChat) == False
	&& StringContains (GlobalPrevRealName, wnProfileExtendedInfo) == FALSE
	&& StringContains (GlobalPrevRealName, wnAddBuddy) == FALSE
	&& StringContains (GlobalPrevRealName, wnFindBuddy) == FALSE
	&& StringContains (GlobalPrevRealName, strFBByEmail) == FALSE
	&& StringContains (GlobalPrevRealName, wnAddBuddyA) == FALSE
	&& StringContains (GlobalPrevRealName, wnAddABuddyComplete) == FALSE
	&& StringContains (GlobalPrevRealName, wnLookupReply) == FALSE) then
	If (StringContains (RealWindowName, wnWelcome)
		|| StringContains (RealWindowName, wnAIMOverview)	
		|| StringContains (RealWindowName, strSetup)) then
		Let nFocusChanged = 1
		ReadNewUserWizardWindows ()
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		Let nDidChange = DidControlChange ()
		Return
	ElIf (StringContains (RealWindowName, wnCreateProfileTips)
		|| StringContains (RealWindowName, wnProfileMoreInfo)
		|| StringContains (RealWindowName, wnProfileDirectory)
		|| StringContains (RealWindowName, wnProfileChat)
		|| StringContains (RealWindowName, wnProfileExtendedInfo)) then
		Let nFocusChanged = 1
		ReadProfileWizardWindows ()
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		Let nDidChange = DidControlChange ()
		Return
	ElIf (StringContains (RealWindowName, wnAddBuddy)
		|| StringContains (RealWindowName, wnFindBuddy)
		|| StringContains (RealWindowName, strFBByEmail)
		|| StringContains (RealWindowName, wnSignOnFriend)
		|| StringContains (RealWindowName, wnAddBuddyA)
		|| StringContains (RealWindowName, wnAddABuddyComplete)
		|| StringContains (RealWindowName, wnLookupReply)) then
		Let nFocusChanged = 1
		ReadAddBuddyWizardWindows ()
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		Let nDidChange = DidControlChange ()
		Return
	EndIf
EndIf
; Test to determine if the active real window is a mamber of the New User Wizard dialog group
	; A single window titled "Welcome!"
If (StringContains (RealWindowName, wnWelcome)
	; Five seperate windows, each with a slightly different window title
		;	1.  AOL Instant Messenger Overview
		;	2.  AOL Instant Messenger Overview - Buddy List
		;	3.  AOL Instant Messenger Overview - Buddy Controls
		;  4.  AOL Instant Messenger Overview - Neighborhood Watch (SM)
		;	5.  AOL Instant Messenger Overview - My Profile
	|| StringContains (RealWindowName, wnAIMOverview)	
	;  A single window titled "Set Up AOL Instant Messenger Now!"
	|| StringContains (RealWindowName, strSetup)) then
	;  Call the function DidControlChange () and store its return value in the variable 
	; nDidChange.  This is to assist in determining if the user is tabbing between controls 
	; of a dialog box or switching between dialog boxes
	Let nDidChange = DidControlChange ()
	; If DidControlChange indicates that the user is not tabbing between controls
	If (nDidChange == 0) then
	If (cwTypeCode == WT_BUTTON && curWinName == wnCancel || curWinName == wnBack) then
			SayWindowTypeAndText (GetCurrentWindow ())
		Else
			Let nFocusChanged = 1
			ReadNewUserWizardWindows ()
		EndIf
	Else
		; If DidControlChange () returned 1, read the active control
		SayWindowTypeAndText (GetCurrentWindow ())
	EndIf
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
ElIf (StringContains (RealWindowName, wnCreateProfileTips)
	|| StringContains (RealWindowName, wnProfileMoreInfo)
	|| StringContains (RealWindowName, wnProfileWarning)
	|| StringContains (RealWindowName, wnProfileDirectory)
	|| StringContains (RealWindowName, wnProfileChat)
	|| StringContains (RealWindowName, wnProfileExtendedInfo)) then
; Call the function DidControlChange () and store its return value in the variable nDidChange.  
; This is to assist in determining if the user is tabbing between controls of a dialog box or 
; switching between dialog boxes
	Let nDidChange = DidControlChange ()
	; If DidControlChange indicates that the user is not tabbing between controls
	If (nDidChange == 0) then
		If (cwTypeCode == WT_BUTTON && curWinName == wnCancel || curWinName == wnBack) then
			SayWindowTypeAndText (GetCurrentWindow ())
		Else
			Let nFocusChanged = 1
			ReadProfileWizardWindows ()
		EndIf
	Else
		; If DidControlChange () returned 1, read the active control
		SayFocusedWindow ()
	EndIf
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
ElIf (StringContains (RealWindowName, wnAddBuddy)
	|| StringContains (RealWindowName, wnFindBuddy)
	|| StringContains (RealWindowName, strFBByEmail)
	|| StringContains (RealWindowName, wnSignOnFriend)
	|| StringContains (RealWindowName, wnAddBuddyA)
	|| StringContains (RealWindowName, wnAddABuddyComplete)
	|| StringContains (RealWindowName, wnLookupReply)
	|| StringContains (RealWindowName, wnSearchFunctionality)) then 
	;  Call the function DidControlChange () and store its return value in the variable nDidChange.  This
	;  is to assist in determining if the user is tabbing between controls of a dialog box or 
	; switching between dialog boxes
	Let nDidChange = DidControlChange ()
	; If DidControlChange indicates that the user is not tabbing between controls
	If (nDidChange == 0) then
		If (cwTypeCode == WT_BUTTON 
			&& (curWinName == wnCancel || curWinName == wnBack || curWinName == wnControls)) then
			SayWindowTypeAndText (GetCurrentWindow ())
		Else
			Let nFocusChanged = 1
			ReadAddBuddyWizardWindows ()
		EndIf
	Else
		; If DidControlChange () returned 1, read the active control
		SayFocusedWindow ()
	EndIf
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
; *** End Wizard Code Block
ElIf (StringContains (RealWindowName, wnBuddyFound)) then
	;  Call the function DidControlChange () and store its return value in the variable 
	; nDidChange.  This is to assist in determining if the user is tabbing between controls 
	; of a dialog box or switching between dialog boxes
	Let nDidChange = DidControlChange ()
	;	If DidControlChange indicates that the user is not tabbing between controls.  
	; FocusChangedEvent (...) is 	always called when this window is activated, so 
	; there is no need for the complicated testing that was done for the window above
	If (nDidChange == 0) then
		ReadMiscWindows ()
	Else
		; If DidControlChange () returned 1, read the active control
		SayWindowTypeAndText (GetCurrentWindow ())
	EndIf
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
ElIf (StringContains (RealWindowName, wnDefaultAwayMessage)
	|| StringContains (RealWindowName, wnNewAwayMessage)
	|| StringContains (RealWindowName, wnIAmNotHere)) then
	Let nDidChange = DidControlChange ()
	If (nDidChange == 0) then
		Say (RealWindowName, ot_message)
		SayFocusedWindow ()
	Else
		SayFocusedWindow ()
	EndIf
	; Set the global variables for next time and return
	let GlobalPrevReal = RealWindow
	let GlobalPrevRealName = RealWindowName
	let GlobalPrevApp = AppWindow
	let GlobalPrevFocus = FocusWindow
	Return
EndIf
; Default focus changed processing
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
  ; we've switched to a different app main window,
  ; and it does not have the focus, so announce it
  SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
    SayWindowTypeAndText (RealWindow)
  endif
EndIf
;let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
  SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
  SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function SayFocusedWindow ()
;Author's Name:
;		Ben Key
;Description:
;	Function designed to read the control that currently has focus.  Used to 
;	customize the speaking	of various controls that the default SayFocusWindow (...) 
;	function speaks incorrectly
;Parameters:
;		None
;Globals
;	Used:
;		GlobalFocusWindow
;	Modified:			
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/29/1999		Ben Key
;	Function added to project
;*****************************************************************************************************************
Void Function SayFocusedWindow ()
Var 
	Handle rWin, Handle curWin, Handle hTarget, Handle hTemp, 
	String rWinTitle, String curWinName, String strTemp, 
	String rWinClass, String curWinClass, Int curID 
Let curWin = GetCurrentWindow ()
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWinName = GetWindowName (curWin)
Let rWinClass = GetWindowClass (rWin)
Let curWinClass = GetWindowClass (curWin)
Let curID = GetControlID (curWin)
; In the "Create a Profile - Searchable Directory" dialog box, there is a check box labeled
; "Allow only AOL Instant Messenger users to be able to see this ...".  Because the 
; label of the check box is made up of the check box label plus an additional static 
; window, JFW only reads  the first portion of the label. 
If (IsIAmAwayDialog ()) then
	If (curID == cID_NULL) then
		Let hTarget = GetFirstChild (rWin)
		Let hTemp = GetNextWindow (hTarget)
		SayWindow (hTarget, READ_EVERYTHING)
		SayWindow (hTemp, READ_EVERYTHING)
		SayWindow (curWin, READ_EVERYTHING)
		Return
	EndIf
ElIf (rWinClass == wcOscarBuddyListWin) then 
	If (curWinClass == wcOscarButton
		&& curID == cID_GoOscarButton) then
		Say (wnGo + " " + msgButton, ot_message)
		Return
	ElIf (curWinClass == wcOscarButton) then
		Say (GetWindowName (GetCurrentWindow ()), OT_CONTROL_NAME)
		Say (msgButton, OT_CONTROL_NAME)
		Return
	ElIf (curWinClass == wcEdit
		&& curID == cID_SearchEdit) then
		Say (wnSearch, ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return
	ElIf (curWinClass == wcOscarTabControl) then
		Say (msgEmptyControl, ot_message)
		If (GetVerbosity () == BEGINNER) then
			Say (msgNoAction, ot_message)
		EndIf
	ElIf (curWinClass == wcOscarTree) then
		If (curID == cID_OnlineBuddyList) then
			Say (wnOnlineBuddyList, ot_message)
		ElIf (curID == cID_ListSetupBuddyList) then
			Say (wnListSetupBuddyList, ot_message)
		EndIf
		SayLine ()
		Return
	EndIf
ElIf (curWinClass == wcOscarButton) then
	Say (GetWindowName (GetCurrentWindow ()), OT_CONTROL_NAME)
	Say (msgButton, OT_CONTROL_NAME)
	Return
ElIf (StringContains (rWinTitle, wnProfileDirectory)
	&& StringContains (curWinName, wnAllowToSee)) then
	SayWindow (GetCurrentWindow (), READ_EVERYTHING)
	Let hTemp = FindDescendantWindow (GetFirstChild (rWin), cID_AllowPrompt)
	If (hTemp) then
		SayWindow (hTemp, READ_EVERYTHING)
	EndIf
	Say (GetWindowType (GetCurrentWindow ()), ot_control_name)
	If (ControlIsChecked ()) then
		Say (msgChecked, ot_control_name)
		Else
			Say (msgUnChecked, ot_message)
	EndIf
	Return
ElIf (StringContains (rWinTitle, wnProfileExtendedInfo)
	&& curWinClass == wcAte32) then
	Say (wnMoreInfoEdit, ot_control_name)
	SayWindow (curWin, READ_EVERYTHING)
	Return
ElIf (StringContains (rWinTitle, wnsegBuddyInfo)) then
	If (rWinClass == wcOscarLocate) then
		If (curWinClass == wcEdit && curID == cID_LookupName) then
			Say (wnLookupName, ot_message)
			Say (wcEdit, ot_message)
			If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then 
				SayChunk ()
			EndIf
			Return
		ElIf (curWinClass == wcAte32 && curID == cID_NULL) then
			Say (wnLookupProfile, ot_message)
			Say (wtLookupProfile, ot_message)
			SayWindow (curWin, READ_EVERYTHING)
			Return
		EndIf
	EndIf
ElIf (StringContains (rWinTitle, wnsegDirectoryInfo)) then
		If (curWinClass == wcAte32 && curID == cID_NULL) then
		Say (wnsegDirectoryInfo, ot_message)
		Say (wtLookupProfile, ot_message)
		Let strTemp = GetWindowText (curWin, FALSE)
		Say (strTemp, ot_message)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnBuddyFound)) then
	If (curID == cID_ScreenNamesFound) then
		Say (wnScreenNamesFound, ot_message)
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnDefaultAwayMessage)) then
	If (curID == cID_SetDefaultAwayMsg) then
		Let hTemp = GetFirstChild (rWin)
		SayWindow (hTemp, READ_EVERYTHING)
		Let hTemp = GetNextWindow (hTemp)
		SayWindow (hTemp, READ_EVERYTHING)
		SayWindow (curWin, READ_EVERYTHING)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnNewAwayMessage)) then
	If (GetWindowClass (curWin) == wcAte32) then
		Say (wnEnterNewAwayMessage + " " + wcEdit, ot_message)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnChooseEntry)
	&& curWinClass == wcAte32) then
	If (GetWindowClass (GetPriorWindow (GetParent (curWin))) == wcButton) then
		Say (wnClientEntry, ot_control_name)
		SayWindow (curWin, READ_EVERYTHING)
		Return
	ElIf (GetWindowClass (GetPriorWindow (GetParent (curWin))) == wcWndAte32) then
		Say (wnHostEntry, ot_control_name)
		SayWindow (curWin, READ_EVERYTHING)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnIAmNotHere)
	&& curWinClass == wcAte32) then
	Let hTarget = GetFirstChild (rWin)
	SayWindow (hTarget, READ_EVERYTHING)
	Let hTarget = GetNextWindow (hTarget)
	SayWindow (hTarget, READ_EVERYTHING)
	SayWindow (curWin, READ_EVERYTHING)
	Return
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction





;*****************************************************************************************************************
;Function:	
;	Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, 
;		int nBackgroundColor, int nEcho, string sFrameName)
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to control the speaking of all text that is written to the screen.  
;	If nSuppressEcho = 1 this function returns without any further processing.  Otherwise, 
;	this function calls the default NewTextEvent (...) function.
;Parameters:
;	handle hwnd
;		The handle of the window in which the text was written
;	string buffer
;		The text that was written to the window
;Globals
;	Used:
;		nSuppressEcho
;	Modified:			
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/29/1999		Ben Key
;	Function added to project
;*****************************************************************************************************************
Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, 
	int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
Var String theClass, String strTest
Let strTest = GetWindowName (GetRealWindow (GetParent (hwnd)))
Let theClass = GetWindowClass (hwnd)
If (theClass == wcAte32
	&& StringContains (strTest, wnSegBuddyInfo)
	&& WindowSpoken == 0) then
	Say (msgMemberInfoFound, ot_message)
	Let WindowSpoken = 1
EndIf
If (nSuppressEcho == TRUE) then 
	Return 
Else
	NewTextEvent (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function SayNonHighlightedText (handle hwnd, string buffer)
;Author's Name:
;		Ben Key
;Description:
;		This function is called by NewTextEvent (...) to control the speaking of non highlighted text.
;		This function is primarily used to control the speaking of various dialog boxes in the AOL
;		Instant Messenger New User Wizard in which focus changed event fails to be called when
; 		moving from one dialog box to the next.   (See comments on FocusChangedEvent (...) for 
;		further details.
; 		The windows that SayNonHighlightedText (...) is allowed to control the speaking of are as 
;		follows:
;		1.		AOL Instant Messenger Overview
;		2.		AOL Instant Messenger Overview - Buddy List
;		3.		AOL Instant Messenger Overview - Buddy Controls
;		4.		AOL Instant Messenger Overview - Neighborhood Watch (SM)
;		5.		AOL Instant Messenger Overview - My Profile."
;Parameters:
;	handle hwnd
;			The handle of the window in which the text was written
;	string buffer
;			The text that was written to the window
;Globals
;	Used:
;		nFocusChanged, WindowSpoken, G_rWinTitle
;	Modified:
;		WindowSpoken, G_rWinTitle
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/23/1999		Ben Key
;	Project started
; 06/28/1999		Ben Key
;	FocusChangedEvent (...) was rewritten to simply do nothing if the Focus
;	Change Occured in one of the overview windows.  All speaking of 
;	these windows is now controled by NewTextEvent (...), 
;	FocusPointMovedEvent (...), and ReadOverViewWindows ().
; 06/28/1999		Ben Key
;	Previous strategy was abandoned.  A new strategy was developed
;	(documented above) that incorporated tighter control over the interraction 
;	between SayNonHighlightedText (...) and FocusChangedEvent (...) and more 
;	returns from DidControlChange ().
; 06/29/1999		Ben Key
;	The strategy that was created yesterday to handle speaking of the 
;	New User Wizard windows was applied to the User Profile Wizard Windows
;*****************************************************************************************************************
Void Function SayNonHighlightedText (handle hwnd, string buffer)
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
Var Handle rWin, String theClass, String prevWinTitle, Int hwndType
Let theClass = GetWindowClass (hwnd)
Let rWin = GetRealWindow (GetFocus ())
Let prevWinTitle = G_rWinTitle
Let G_rWinTitle = GetWindowName (rWin)
Let hwndType = GetWindowSubtypeCode (hwnd)
; Always speak the Alt + Tab Window
;wcAltTab="#32771"
if ((GetScreenEcho() > 1) 
	|| (TheClass == wcAltTab )) then 
	Say (buffer, ot_buffer) 
	Return
EndIf
If (StringContains (G_rWinTitle, wnProfileExtendedInfo)
	&& theClass == wcAte32) then
	Return
EndIf
If (GlobalMenuMode != MENU_INACTIVE) then
	Return
EndIf
If (nFocusChanged == 0 
	&& WindowSpoken == 0) then	
	If (StringContains (G_rWinTitle, wnAIMOverview)
		|| StringContains (G_rWinTitle, strSetup)) then
		ReadNewUserWizardWindows ()
	ElIf (StringContains (G_rWinTitle, wnCreateProfileTips)
		|| StringContains (G_rWinTitle, wnProfileMoreInfo)
		|| StringContains (G_rWinTitle, wnProfileDirectory)
		|| StringContains (G_rWinTitle, wnProfileChat)
		|| StringContains (G_rWinTitle, wnProfileExtendedInfo)) then
		If (hwndType == WT_EDIT) then
			Return
		EndIf
		If (GetWindowSubtypeCode (GetCurrentWindow ()) == WT_CHECKBOX) then
			Return
		EndIf
		ReadProfileWizardWindows ()
	ElIf (StringContains (G_rWinTitle, wnAddBuddy)
		|| StringContains (G_rWinTitle, wnFindBuddy)
		|| StringContains (G_rWinTitle, strFBByEmail)
		|| StringContains (G_rWinTitle, wnSignOnFriend)
		|| StringContains (G_rWinTitle, wnAddBuddyA)
		|| StringContains (G_rWinTitle, wnAddABuddyComplete)) then
		If (hwndType == WT_EDIT) then
			Return
		EndIf
		ReadAddBuddyWizardWindows ()
	EndIf
EndIf
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
Var String rWinTitle, String hwndClass
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hwndClass = GetWindowClass (hwnd)
If (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectItemDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectScriptDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (hwndClass == wcSysTabControl) then
	If (numTimes == 0) then
		Say (buffer, ot_buffer)
		Let numTimes = 1
	ElIf (numTimes != 0) then
		Return
	EndIf
Else
	SayHighLightedText (hwnd, buffer)
EndIf
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
;Author's Name:
;		Ben Key
;Description:
;	This function is designed to control actions that must occur any time a key is pressed.  
;	Its only use here is to reset the values of the global variables WindowSpoken and 
;	nFocusChanged to 0.
;Parameters:
;	int nKey
;			the numeric keycode
;	string strKeyName
;			the name as it would be used in a keymap
;	int nIsBrailleKey
;			1 if this was a key on the Braille Display
;	int nIsScriptKey
;		1 if this key is assigned to a script
;Globals
;	Used:				
;	Modified:
;		nFocusChanged, WindowSpoken
;Return Value:
;	Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/28/1999		Ben Key
;		Function created
;*****************************************************************************************************************
Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
If (strKeyName == KeyPageUp || strKeyName == KeyPageDown) then
	Let WindowSpoken = 1
Else
	Let WindowSpoken = 0
	Let nFocusChanged = 0
EndIf
EndFunction

; ***/  Scripts
;*****************************************************************************************************************
;Script:	
;		Script  ScriptFileName()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to say the script and application name by calling the function
;  	ScriptAndAppNames with the string parameter AOL Instant messenger 
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/23/1999		Ben Key
;		Script created
;*****************************************************************************************************************
Script  ScriptFileName()
ScriptAndAppNames(msgAimScriptFile) ;msgSAimcriptFile = "AOL Instant messenger",
EndScript

;*****************************************************************************************************************
;Script:	
;		Script  ListSelectedInterests ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to say the selected interests in the "Create a Profile - Chat Interests"
;  dialog.
;  The interest are chosen by pressing each of the five choose interest buttons.  When pressed,
;  a context menu appears from which the user can select his particular interests.  The user
;  can choose to list no interests, or he may choose to list up to five.  After an interest has been 
;  selected, it appears in an edit box located to the right of the choose interest button.  There 
;	are five edit boxes, one for each choose interest button.  The edit boxes have the following 
;  control ID's:  465, 466, 467, 468, 469.
;  This script will search for each of the windows, determine if they contain any text, copy the 
;	text  to a string buffer, and then inform the user of how many interests they have selected, 
;	and finally list the selected interests
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/29/1999		Ben Key
;		Script created
;*****************************************************************************************************************
Script ListSelectedInterests ()
Var Handle rWin, String rWinTitle, String strInterestList, Handle hTemp, 
	Int nCID, Int nCount, Int numItems, String strTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnProfileChat) == 0) then
	Say (msgNotInInterest, ot_message)
	Return
Else
	Let numItems = 0
	Let strInterestList = ""
	Let strTemp = ""
	Let nCount = 0
	Let nCID = cID_EditBase
	While (nCount < 5)
		Let hTemp = FindDescendantWindow (GetFirstChild (rWin), nCID)
		If (hTemp) then
			Let strTemp = GetWindowText (hTemp, FALSE)
			If (strTemp != "") then
				Let numItems = numItems + 1
				Let strInterestList = strInterestList + msgHardReturn + msgHardReturn + strTemp
				Let strTemp = ""
			EndIf
		EndIf
		Let nCount = nCount + 1
		Let nCID = nCID + 1
	EndWhile
	If (strInterestList != "") then
;	msgHaveSel = "You have selected ",
; msgInterest = " Interest ",
;	msgInterests = " interests ",
;	msgTheyAre = " They are ",
; msgItIs = " It is ",
; msgAsFollows = " as follows: ",
		If (numItems > 1) then
			Say (msgHaveSel + IntToString (numItems) + msgInterests, ot_message)
			Say (msgTheyAre + msgAsFollows, ot_message)
			Say (strInterestList, ot_message)
		ElIf (numItems == 1) then
			Say (msgHaveSel + IntToString (numItems) + msgInterest, ot_message)
			Say (msgItIs + msgAsFollows, ot_message)
			Say (strInterestList, ot_message)
		EndIf
	Else
		If (hTemp != 0) then
			Say (msgNoInterests, ot_message)
		ElIf (hTemp == 0) then
			Say (msgCouldNotFindInterests, ot_message)
		EndIf
	EndIf
EndIf
EndScript

;*****************************************************************************************************************
;Script:	
;		Script SelectATool ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to allow the user to easily activate buttons on the  various toolbars in 
;	AOL Instant Messenger
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/29/1999		Ben Key
;		Script created
;*****************************************************************************************************************
Script SelectATool ()
Var Handle rWin, String rWinTitle, handle winHandle, int nItem, 
	String strButtonList, String strSelectedTool
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnProfileExtendedInfo)) then
	let winHandle = GetProfileMoreInfoToolbar ()
	if (!winHandle || !IsWindowVisible (winHandle)) then
		return
	EndIf
	Let strButtonList = GetButtonList (winHandle)
	let nItem = dlgSelectItemInList (strButtonList + wnBack + "\007" + wnFinish + "\007" + wnCancel, 
		ProfileToolbarDialogName, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList + wnBack + "\007" + wnFinish + "\007" + wnCancel, 
			"\007", nItem)
		let nSuppressEcho = true
		delay (2)
		ClickToolBarButton (winHandle, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
ElIf (StringContains (rWinTitle, wnNewAwayMessage)) then
	If (GetWindowClass (GetCurrentWindow ()) != wcAte32) then 
		Say (msgActiveWinMustBe + " " + wnEnterNewAwayMessage + " " + msgInOrderToolBar, ot_message)
		Return
	EndIf
	let winHandle = GetNewAwayMsgToolBar ()
	if (!winHandle || !IsWindowVisible (winHandle)) then
		return
	EndIf
	Let strButtonList = GetButtonList (winHandle)
	let nItem = dlgSelectItemInList (strButtonList, NewAwayMsgToolBarDialogName, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
		let nSuppressEcho = true
		delay (2)
		ClickToolBarButton (winHandle, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
ElIf (GetWindowClass (rWin) == wcOscarBuddyListWin) then
	Let strButtonList = GetButtonList (0)
	let nItem = dlgSelectItemInList (strButtonList, BuddyListToolBarDialog, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
		let nSuppressEcho = true
		delay (2)
		ClickToolBarButton (0, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
EndIf
EndScript

;*****************************************************************************************************************
;Script:	
;		Script ScreenSensitiveHelp ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to customize the screen sensitive for various controls found throughout 
;	AOL Instant Messenger that have unknown window types.
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;														MODIFICATION LOG
;														================
; 06/29/1999		Ben Key
;		Script created
;*****************************************************************************************************************
Script ScreenSensitiveHelp ()
var handle WinHandle, int TheTypeCode, String TheClass,
	String rWinTitle, Handle rWin, String strTemp
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (TheClass == wcAte32 
	&& StringContains (rWinTitle, wnProfileExtendedInfo)) then
	Say (shmsg_MoreInfoEdit, ot_help)
	Say (shmsg_MayUseTo, ot_help)
	Say (shmsg_Formatting, ot_help)
	Say (shmsg_ToolBarA + GetScriptKeyName ("SelectATool"), ot_help)
	Say (shmsg_AccessButtons, ot_help)
	Say (shmsg_ClickButtons, ot_help)
	Return
ElIf (TheClass == wcOscarTree 
	&& GetWindowClass (GetParent (WinHandle)) == wcOscarTabGroup) then
	Let strTemp = GetActivePageName ()
	Say (shmsg_ThisIsThe, ot_help)
 	Say (strTemp, ot_help)
	Say (shmsg_PageOfList, ot_help)
	Say (shmsg_SimularTreeView, ot_help)
	Say (shmsg_BuddyListUpDownArrow, ot_help)
	Say (shmsg_BuddyListRightLeftArrow, ot_help)
  If (strTemp == OnlinePage) then
		Say (shmsg_BuddyListPageShowsGeneric, ot_help)
		Say (shmsg_ThatAreOnline, ot_help)
 	ElIf (strTemp == ListSetupPage) then
		Say (shmsg_BuddyListPageShowsGeneric, ot_help)
		Say (shmsg_Regardless, ot_help)
	EndIf
	Return
ElIf (TheClass == wcOscarButton) then
	let strTemp = GetWindowName (GetCurrentWindow ())
	If (GetWindowClass (rWin) == wcOscarBuddyListWin
		&& GetCurrentControlID () == cID_GoOscarButton) then
		Let strTemp = wnGo
	EndIf
	Say (kcmsg001, ot_help) ;"This is the"
	Say (strTemp, ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
ElIf (GetWindowClass (rWin) == wcOscarBuddyListWin
	&& TheClass == wcEdit) then 
	Say (shmsg_WebSearchEdit, ot_help)
	Say (shmsg_WebSearchEditA, ot_help)
	Say (shmsg_WebSearchEditB, ot_help)
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (StringContains (rWinTitle, wnDefaultAwayMessage)
	&& GetCurrentControlID () == cID_SetDefaultAwayMsg) then
	Say (shmsg_SetAwayMsg, ot_help)
	Say (shmsg_SetAwayMsgA + strSpace + rWinTitle + strSpace + shmsg_SetAwayMsgB, ot_help)
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (IsIAmAwayDialog ()) then
	Say (shmsg_SetMessage + strSpace + rWinTitle + strSpace + shmsg_AwayMessage, ot_help)
	Say (shmsg_SetAwayMsgA + strSpace + rWinTitle + strSpace + shmsg_SetAwayMsgB, ot_help)
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return

ElIf (StringContains (rWinTitle, wnNewAwayMessage)
	&& TheClass == wcAte32) then
	Say (shmsg_ThisIsThe + " " + wnEnterNewAwayMessage + " "  + msgEditBox, ot_help)
	Say (shmsg_EnterAwayMsg, ot_help)
	Say (shmsg_Formatting, ot_help)
	Say (shmsg_Toolbar + " " + GetScriptKeyName ("SelectATool"), ot_help)
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

;*****************************************************************************************************************
;Script:	
;		Script SayNextLine ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to customize the SayNextLine () script for various controls found in AIM
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/30/1999		Ben Key					Script created
;*****************************************************************************************************************
Script SayNextLine ()
Var 
	String rWinTitle, String curWinClass, 
	String curWinName, Handle curWin, 
	Int nL, Int nR, Handle rWin
If (!IsPCCursor ()) Then
	PerformScript SayNextLine()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (curWinClass == wcOscarTree
	&& GlobalMenuMode == MENU_INACTIVE) then
	NextLine ()
	SayLine ()
	Return
ElIf (StringContains (rWinTitle, wnSignOnFriend)) then
	If (curWinClass == wcEdit && StringContains (curWinName, wnSignOnFriendMessageEdit)) then
		NextLine ()
		Let nL = GetWindowLeft (curWin)
		Let nR = GetWindowRight (curWin)
		SayTextBetween (nL, nR)
		Return
	EndIf
ElIf (curWinClass == wcAte32) then
	NextLine ()
	Let nL = GetWindowLeft (curWin)
	Let nR = GetWindowRight (curWin)
	SayTextBetween (nL, nR)
	Return
EndIf
PerformScript SayNextLine()
EndScript

;*****************************************************************************************************************
;Script:	
;		Script SayPriorLine ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to customize the SayPriorLine () script for various controls found in 
;	AIM
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/30/1999		Ben Key
;	Script created
;*****************************************************************************************************************
Script SayPriorLine ()
Var 
	String rWinTitle, String curWinClass, 
	String curWinName, Handle curWin, 
	Int nL, Int nR, Handle rWin
If (!IsPCCursor ()) Then
	PerformScript SayPriorLine()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (curWinClass == wcOscarTree
	&& GlobalMenuMode == MENU_INACTIVE) then
	PriorLine ()
	SayLine ()
	Return
ElIf (StringContains (rWinTitle, wnSignOnFriend)) then
	If (curWinClass == wcEdit && StringContains (curWinName, wnSignOnFriendMessageEdit)) then
		PriorLine ()
		Let nL = GetWindowLeft (curWin)
		Let nR = GetWindowRight (curWin)
		SayTextBetween (nL, nR)
		Return
	EndIf
ElIf (curWinClass == wcAte32) then
	PriorLine ()
	Let nL = GetWindowLeft (curWin)
	Let nR = GetWindowRight (curWin)
	SayTextBetween (nL, nR)
	Return
EndIf
PerformScript SayPriorLine()
EndScript

Script SayNextCharacter ()
Var 
	String curWinClass, Handle curWin 
If (!IsPCCursor ()) Then
	PerformScript SayNextCharacter()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
If (curWinClass == wcOscarTree
	&& GlobalMenuMode == MENU_INACTIVE) then
	NextCharacter ()
	SayLine ()
	Return
EndIf
PerformScript SayNextCharacter()
EndScript

Script SayPriorCharacter ()
Var 
	String curWinClass, Handle curWin 
If (!IsPCCursor ()) Then
	PerformScript SayPriorCharacter ()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
If (curWinClass == wcOscarTree
	&& GlobalMenuMode == MENU_INACTIVE) then
	PriorCharacter ()
	SayLine ()
	Return
EndIf
PerformScript SayPriorCharacter()
EndScript

Script NextDocumentWindow ()
Var String strPageName, Handle rWin, String rWinClass, 
	String strTemp
Let rWin = GetRealWindow (GetFocus())
Let rWinClass = GetWindowClass (rWin)
If (rWinClass == wcOscarBuddyListWin) then
	{Control + Tab}
	Pause ()
	Say (GetActivePageName () + " " + msgPage, ot_message)
Else
	PerformScript NextDocumentWindow ()
EndIf
EndScript

Script PreviousDocumentWindow ()
Var String strPageName, Handle rWin, String rWinClass, 
	String strTemp
Let rWin = GetRealWindow (GetFocus())
Let rWinClass = GetWindowClass (rWin)
If (rWinClass == wcOscarBuddyListWin) then
	{Shift + Control + Tab}
	Pause ()
	Say (GetActivePageName () + " " + msgPage, ot_message)
Else
	PerformScript PreviousDocumentWindow ()
EndIf
EndScript

Script  JawsPageDown()
Var Handle rWin, String rWinTitle, Handle curWin, String curWinClass
Let curWin = GetCurrentWindow ()
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWinClass = GetWindowClass (curWin)
If (StringContains (rWinTitle, wnsegBuddyInfo)
	|| StringContains (rWinTitle, wnsegDirectoryInfo)) then
	If (curWinClass == wcAte32 
		&& GetCurrentControlID () == cID_NULL) then
		{PageDown}
		Pause ()
		SayWindow (curWin, READ_EVERYTHING)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnChooseEntry)
	&& curWinClass == wcAte32) then
		{PageDown}
		Pause ()
		SayWindow (curWin, READ_EVERYTHING)
		Return
EndIf
PerformScript JawsPageDown()
EndScript

Script  JawsPageUp()
Var Handle rWin, String rWinTitle, Handle curWin, String curWinClass
Let curWin = GetCurrentWindow ()
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWinClass = GetWindowClass (curWin)
If (StringContains (rWinTitle, wnsegBuddyInfo)
	|| StringContains (rWinTitle, wnsegDirectoryInfo)) then
	If (curWinClass == wcAte32 
		&& GetCurrentControlID () == cID_NULL) then
		{PageUp}
		Pause ()
		SayWindow (curWin, READ_EVERYTHING)
		Return
	EndIf
ElIf (StringContains (rWinTitle, wnChooseEntry)
	&& curWinClass == wcAte32) then
		{PageUp}
		Pause ()
		SayWindow (curWin, READ_EVERYTHING)
		Return
EndIf
PerformScript JawsPageUp()
EndScript

Script JawsDelete()
Var String curWinClass
Let curWinClass = GetWindowClass (GetCurrentWindow ())
If (curWinClass == wcOscarTree) then
	SaveCursor ()
	PCCursor ()
	{Delete}
	Return
Else
	PerformScript JawsDelete()
EndIf
EndScript

Void Function HotKeyLoop ()
Var Handle rWin, Handle hFirstChild, Handle hTemp, Int nTypeCode, 
Int FoundHotKey, String strHelpPhrase, String strType, String strName
Let nNextSpoken = 0
Let FoundHotKey = 0
Let strHelpPhrase = ""
Let rWin = GetRealWindow (GetFocus ())
Let hFirstChild = GetFirstChild (rWin)
Let hTemp = hFirstChild
SaveCursor ()
InvisibleCursor ()
While (hTemp)
	let nTypeCode = GetWindowTypeCode (hTemp)
	If ((nTypeCode == WT_BUTTON) ||
		(nTypeCode == WT_STATIC) ||
		(nTypeCode == WT_RADIOBUTTON) ||
		(nTypeCode == WT_CHECKBOX) ||
		(nTypeCode == WT_GROUPBOX) ||
		(nTypeCode == WT_3STATE) ||
		(nTypeCode == WT_TABCONTROL)) then
		MoveToWindow (hTemp)
		;strNull=""
		if (GetHotKey() != strNull) then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (hkmsgHotKeysAre, ot_help)	;"Hot keys are as follows:"
			EndIf
			If (nTypeCode == WT_BUTTON) then
				Let strType = TypeButton
			ElIf (nTypeCode == WT_STATIC) then
				Let strType = TypeStatic
			ElIf (nTypeCode == WT_RADIOBUTTON) then
				Let strType = TypeRadioButton
			ElIf	(nTypeCode == WT_CHECKBOX) then
				Let strType = TypeCheckBox
			ElIf (nTypeCode == WT_GROUPBOX) then
				Let strType = TypeGroupBox
			ElIf (nTypeCode == WT_TABCONTROL) then
				Let strType = TypeTabControl
			EndIf
			Let strName = GetWindowName (GetCurrentWindow ())
			If (strName != wnNext) then
				Let strHelpPhrase = hkmsgForThe + strSpace + GetWindowName (GetCurrentWindow ()) + strSpace + strType + 
					strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
				Say (strHelpPhrase, ot_help)
				let FoundHotKey = 1
			ElIf (strName == wnNext) then
				If (nNextSpoken == 0) then
					Let strHelpPhrase = hkmsgForThe + strSpace + GetWindowName (GetCurrentWindow ()) + strSpace + strType + 
						strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
					Say (strHelpPhrase, ot_help)
					let FoundHotKey = 1
					Let nNextSpoken = 1
				ElIf (nNextSpoken != 0) then

				EndIf
			EndIf
;			Let strHelpPhrase = hkmsgForThe + strSpace + GetWindowName (GetCurrentWindow ()) + strSpace + strType + strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
;				Say (strHelpPhrase, ot_help)
;				let FoundHotKey = 1
		EndIf
	EndIf ; condition for static text or button
	Let hTemp = GetNextWindow (hTemp)
EndWhile
RestoreCursor ()
If (FoundHotKey == 0) then
	If (IsEditPreferencesDialog ()) then
		Say (hkmsgNoHotKeys, ot_help)
	ElIf (DialogActive ()) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		Say (hkmsgUnable, ot_help)
	EndIf
EndIf
EndFunction

Script HotKeyHelp ()
Var Handle rWin, String rWinTitle, String rWinClass, Handle curWin, String curWinClass,
	Handle hBack, Handle hNext, String strTemp, String strButtonName
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let rWinClass = GetWindowClass (rWin)
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
If (rWinClass == wcOscarBuddyListWin) then 
	If (curWinClass == wcOscarTree) then
		Say (hkmsgPress + " "  + GetScriptKeyName ("NextDocumentWindow") + " " + hkmsgSwitchTo, ot_help)
		If (GetActivePageName () == hkmsgOnlinePage) then
			Say (hkmsgListSetupPage, ot_help)
		ElIf (GetActivePageName () == hkmsgListSetupPage) then
			Say (hkmsgListSetupPage, ot_help)
		EndIf
		Say (hkmsgPageOf, ot_help)
		If (GetActivePageName () == hkmsgOnlinePage) then
			Say (hkmsgGetInfo + " " + hkmsgSelBuddy + " "  + hkmsgGetInfoA, ot_help)
			Say (hkmsgSendMessage + " " + hkmsgSelBuddy + " " + hkmsgSendMessageA, ot_help)
			Say (hkmsgSendChat + " " + hkmsgSelBuddy + " " + hkmsgSendChatA, ot_help) 
		EndIf
		Say (hkmsgAIMHelp, ot_help)
		Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
		Return
	ElIf (curWinClass == wcOscarButton 
		|| curWinClass == wcEdit) then
		Say (hkmsgAIMHelp, ot_help)
		Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
		Return
	EndIf
ElIf (rWinClass == wcDialog 
	&& GetWindowClass (GetFirstChild (rWin)) == wcDialog) then
;	HotKeyHelpDefaultLoop ()
	If (StringContains (rWinTitle, wnProfileChat)) then
		Say (hkmsgListInterests + strSpace + shmsg_press + strSpace + GetScriptKeyName ("ListSelectedInterests") , ot_help)
	EndIf
	HotKeyLoop ()
	Return
ElIf (StringContains (rWinTitle, wnsegBuddyInfo)) then
; There are three buttons in this window.  They are IM, Add Buddy, and Directory Info.  In 
; each of these buttons, GetHotKey () fails.  Therefore it is necessary to hard code the 
; messages.
	Say (hkmsgForIMButton, ot_help)
	Say (hkmsgForAddBuddyButton, ot_help)
	Say (hkmsgForDirectoryInfoButton, ot_help)
	Return
ElIf (StringContains (rWinTitle, wnsegDirectoryInfo)) then
; There are no controls with hot keys in this dialog.  Prevent general messages from being 
; spoken.
	Say (hkmsgNoHotKeys, ot_help)
	Return
EndIf
EndScript

Script  SayWindowPromptAndText()
;SayWindowTypeAndText(GetCurrentWindow())
SayFocusedWindow ()
EndScript

Script ClearMessageDisplayWindowOnEnter ()
Var Int iTypeEcho
Let iTypeEcho = GetJCFOption (OPT_TYPING_ECHO)
{Enter}
If (iTypeEcho > 0) Then
	Say (msgEnter, ot_message)
EndIf
EndScript

Script ClearMessageDisplayWindow ()
PerformScript SayProgramComments()
EndScript

Script ToggleClearMessageDisplayWindowOption ()
Var Int iTypeEcho
Let iTypeEcho = GetJCFOption (OPT_TYPING_ECHO)
{Control + Shift + T}
If (iTypeEcho > 0) Then
	Say (msgCtrlShiftT, ot_message)
EndIf
EndScript